              
/*****************************************************************************
*                           Freescale Semiconductor                          *
*                   Brazilian Semiconductor Tecnology Center                 *
*                                                                            *
*  Project    : MC56F8006 Modular Pixel Matrix                               *
*  Version    : 0.1                                                          *
*  Date       : 27/Apr/2009                                                  *
*  Engineers  : Alexandre Dias, Bruno Bastos                                 *
*               Humberto Carvalho, Leonardo Mangiapelo                       *
*               Renato Frias                                                 *
*                                                                            *
* -------------------------------------------------------------------------- *
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR        *
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES  *
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.    *
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,  *
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES         *
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR         *
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)         *
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,        * 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING      *
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF             *
* THE POSSIBILITY OF SUCH DAMAGE.                                            *
* -------------------------------------------------------------------------- *
*  Description:                                                              *
* This software complements AN3815 - Implementing a Modular High Brightness  *
* RGB LED Network. The aim of the code is to proof the concept described on  *
* the application note document. It also serves as a starting point for      * 
* applications with MC56F8006 and some of its peripherals                    *
* -------------------------------------------------------------------------- *
*                                                                            *
*  File: rs885.h	                                                         *
*                                                                            *
*    Header file for rs485.c 												 * 
*                                                                            *
******************************************************************************/

/************************* Project Include Files *****************************/

#ifndef _rs845_H
#define _rs485_H

#include "mc56f8006.h"

/********************************* Defines ***********************************/

#define BSP_OSCILLATOR_FREQ 		8000000L
#define PLL_MUL                     1L
#define PLL_POSTSCALER				(1<<0)	/* 1,2,4,8,16,32 */
#define SCI_CLOCK_HZ				(BSP_OSCILLATOR_FREQ * PLL_MUL / PLL_POSTSCALER / 2 )
#define PrintDigit(d)				TERMIO_PrintDigit(d)
#define Print(s)					TERMIO_Print((int8_t*)s)
#define PrintInfo2(s1,s2)			Print((int8_t*)s1);	Print((int8_t*)" : "); Print((int8_t*)s2);Print((int8_t*)"\r\n")
#define PrintErr2(s1,s2)			Print((int8_t*)"Error: "); PrintInfo2(s1,s2)
#define SCI_BAUDRATE_115k2  4400l
#define SCI_BAUDRATE_6M 	200000l
#define SCI_BAUDRATE_3M 	100000l


/****************************** Prototypes ***********************************/

void TERMIO_PutChar(int8_t send); 
int8_t TERMIO_GetChar(void); 
void TERMIO_Print(int8_t * str );
void TERMIO_PrintDigit(uint16_t number) ;
void rs485_init(uint32_t baudrate);
extern void TERMIO_Print(int8_t *str);

#endif